#!/bin/bash
#SBATCH -N 1
#SBATCH --partition=exfel
#SBATCH --time=12:00:00
#SBATCH --mail-type=END,FAIL
#SBATCH --output=logs/%j-%x.out

while getopts ":p:d:r:k:m:x:b:" option
do
    case $option in
        p) PROPOSAL="$OPTARG";;
        d) DARK="$OPTARG";;
        r) RUN="$OPTARG";;
        k) KERNEL="$OPTARG";;
        m) MODULE_GROUP="$OPTARG";;
        x) XAXIS="$OPTARG";;
        b) BINWIDTH="$OPTARG";;
        \?) echo "Unknown option"
            exit 1;;
        :) echo "Missing option for input flag"
           exit 1;;
    esac
done

# Load xfel environment
source /etc/profile.d/modules.sh
module load exfel exfel-python

echo processing run $RUN
PDIR=$(findxfel $PROPOSAL)
PPROPOSAL="p$(printf '%06d' $PROPOSAL)"
RDIR="$PDIR/usr/processed_runs/r$(printf '%04d' $RUN)"
mkdir $RDIR

NB='Dask DSSC module binning.ipynb'

# kernel list can be seen from 'jupyter kernelspec list'
if [ -z "${KERNEL}" ]; then
	  KERNEL="toolbox_$PPROPOSAL"
fi

python -c "import papermill as pm; pm.execute_notebook(\
  '$NB', \
  '$RDIR/output$MODULE_GROUP.ipynb', \
  kernel_name='$KERNEL', \
  parameters=dict(proposalNB=int('$PROPOSAL'), \
                  dark_runNB=int('$DARK'), \
                  runNB=int('$RUN'), \
                  module_group=int('$MODULE_GROUP'), \
                  path='$RDIR/', \
                  xaxis='$XAXIS', \
                  bin_width=float('$BINWIDTH')))"
