#!/bin/bash
#SBATCH -N 1
#SBATCH --partition=allgpu
#SBATCH --constraint=V100
#SBATCH --time=2:00:00
#SBATCH --mail-type=END,FAIL
#SBATCH --output=logs/%j-%x.out

ROISTH='1'
SATLEVEL='500'
MODULE='15'

while getopts ":p:d:r:k:g:t:s:m:" option
do
    case $option in
        p) PROPOSAL="$OPTARG";;
        d) DARK="$OPTARG";;
        r) RUN="$OPTARG";;
        k) KERNEL="$OPTARG";;
        g) GAIN="$OPTARG";;
        t) ROISTH="$OPTARG";;
        s) SATLEVEL="$OPTARG";;
        m) MODULE="$OPTARG";;
        \?) echo "Unknown option"
            exit 1;;
        :) echo "Missing option for input flag"
           exit 1;;
    esac
done

# Load xfel environment
source /etc/profile.d/modules.sh
module load exfel exfel-python

echo processing run $RUN
PDIR=$(findxfel $PROPOSAL)
PPROPOSAL="p$(printf '%06d' $PROPOSAL)"
RDIR="$PDIR/usr/processed_runs/r$(printf '%04d' $RUN)"
mkdir $RDIR

NB='BOZ analysis part I.a Correction determination.ipynb'

# kernel list can be seen from 'jupyter kernelspec list'
if [ -z "${KERNEL}" ]; then
	KERNEL="toolbox_$PPROPOSAL"
fi

python -c "import papermill as pm; pm.execute_notebook(\
  '$NB', \
  '$RDIR/output.ipynb', \
  kernel_name='$KERNEL', \
  parameters=dict(proposal=int('$PROPOSAL'), \
                  darkrun=int('$DARK'), \
                  run=int('$RUN'), \
                  module=int('$MODULE'), \
                  gain=float('$GAIN'), \
                  rois_th=float('$ROISTH'), \
                  sat_level=int('$SATLEVEL')))"
